/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.config;

import com.flemmli97.improvedmobs.ImprovedMobs;
import com.flemmli97.improvedmobs.config.Config;
import com.flemmli97.improvedmobs.utils.ItemAI;
import com.flemmli97.improvedmobs.utils.ItemAITasks;
import com.flemmli97.tenshilib.api.config.ExtendedItemStackWrapper;
import com.flemmli97.tenshilib.common.utils.ItemUtils;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ThrowablePotionItem;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class EquipmentList {
    private static final Map<EquipmentSlotType, WeightedItemstackList> equips = new HashMap<EquipmentSlotType, WeightedItemstackList>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Field techGunDmg;
    private static Field techgunAIAttackTime;
    private static Field techgunAIBurstCount;
    private static Field techgunAIburstAttackTime;
    private static final List<String> defaultZeroWeight;

    public static ItemStack getEquip(MobEntity e, EquipmentSlotType slot, float difficulty) {
        WeightedItemstackList eq = equips.get(slot);
        if (eq == null || eq.list.isEmpty() || eq.getTotalWeight(difficulty) <= 0) {
            return ItemStack.field_190927_a;
        }
        int index = e.field_70170_p.field_73012_v.nextInt(eq.getTotalWeight(difficulty));
        for (WeightedItemstack entry : eq.list) {
            if ((index -= entry.getWeight(difficulty)) >= 0) continue;
            return entry.getItem();
        }
        return ItemStack.field_190927_a;
    }

    public static void initEquip() throws InvalidItemNameException {
        try {
            File conf = FMLPaths.CONFIGDIR.get().resolve("improvedmobs").resolve("equipment.json").toFile();
            JsonObject confObj = new JsonObject();
            ArrayList errors = new ArrayList();
            if (!conf.exists()) {
                EquipmentList.initDefaultVals();
                conf.createNewFile();
            } else {
                FileReader reader = new FileReader(conf);
                confObj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (confObj == null) {
                    confObj = new JsonObject();
                }
                reader.close();
                for (EquipmentSlotType key : EquipmentSlotType.values()) {
                    if (!confObj.has(key.toString())) continue;
                    JsonObject obj = (JsonObject)confObj.get(key.toString());
                    if (!obj.entrySet().isEmpty()) {
                        obj.entrySet().forEach(ent -> {
                            float quality;
                            int weight;
                            if (((JsonElement)ent.getValue()).isJsonPrimitive()) {
                                weight = ((JsonElement)ent.getValue()).getAsInt();
                                quality = EquipmentList.correctQuality((String)ent.getKey()) ? EquipmentList.defaultQualityFromWeight(weight) : 0.0f;
                            } else {
                                JsonArray entry = ((JsonElement)ent.getValue()).getAsJsonArray();
                                weight = entry.get(0).getAsInt();
                                quality = entry.get(1).getAsFloat();
                            }
                            equips.compute(key, (s, l) -> l == null ? new WeightedItemstackList(new WeightedItemstack((String)ent.getKey(), weight, quality, errors)) : l.add(new WeightedItemstack((String)ent.getKey(), weight, quality, errors)));
                        });
                        continue;
                    }
                    equips.put(key, new WeightedItemstackList(new WeightedItemstack[0]));
                }
            }
            JsonArray comment = new JsonArray();
            comment.add("Mobs will be able to equip items declared here");
            comment.add("The first number is the weight while the second number is the quality");
            comment.add("Weight is the weight of an item. Higher weight means that the item is more likely to get choosen");
            comment.add("Quality is a modifier applied to the weight. The final weight used is weight + quality * current difficulty");
            confObj.add("__comment", (JsonElement)comment);
            for (EquipmentSlotType key : EquipmentSlotType.values()) {
                JsonObject eq = confObj.has(key.toString()) ? (JsonObject)confObj.get(key.toString()) : new JsonObject();
                equips.get(key).list.forEach(w -> {
                    JsonArray entry = new JsonArray();
                    entry.add((Number)((WeightedItemstack)w).weight);
                    entry.add((Number)Float.valueOf(((WeightedItemstack)w).quality));
                    eq.add(w.configString, (JsonElement)entry);
                });
                JsonObject sorted = new JsonObject();
                ArrayList member = new ArrayList();
                eq.entrySet().forEach(ent -> member.add(ent.getKey()));
                Collections.sort(member);
                member.forEach(s -> sorted.add(s, eq.get(s)));
                confObj.add(key.toString(), (JsonElement)sorted);
                equips.get(key).finishList();
            }
            conf.delete();
            conf.createNewFile();
            JsonWriter wr = GSON.newJsonWriter((Writer)new FileWriter(conf));
            GSON.toJson((Object)confObj, JsonObject.class, wr);
            wr.close();
            if (!errors.isEmpty()) {
                throw new InvalidItemNameException("No items with following names exist: " + errors);
            }
        }
        catch (IOException | IllegalStateException e) {
            ImprovedMobs.logger.error("Error initializing equipment");
            e.printStackTrace();
        }
    }

    private static void initDefaultVals() {
        ForgeRegistries.ITEMS.forEach(item -> {
            ItemAI ai;
            if (item instanceof BowItem) {
                EquipmentList.addItemTo(EquipmentSlotType.MAINHAND, item);
            }
            if ((ai = ItemAITasks.getAI(item)) != null) {
                switch (ai.prefHand()) {
                    case BOTH: {
                        if (ai.type() == ItemAI.ItemType.NONSTRAFINGITEM) {
                            float[] weights = EquipmentList.getDefaultWeight(item);
                            WeightedItemstack val = new WeightedItemstack((Item)item, (int)weights[0], weights[1]);
                            if (equips.get(EquipmentSlotType.MAINHAND).list.contains(val)) break;
                            equips.compute(EquipmentSlotType.OFFHAND, (s, l) -> l == null ? new WeightedItemstackList(val) : l.add(val));
                            break;
                        }
                        if (item instanceof ThrowablePotionItem) {
                            String potionItem = item.getRegistryName().toString() + "{Potion:\"minecraft:harming\"}";
                            float[] weights = EquipmentList.getDefaultWeight(item);
                            equips.compute(EquipmentSlotType.MAINHAND, (s, l) -> l == null ? new WeightedItemstackList(new WeightedItemstack(potionItem, (int)weights[0], weights[1], new ArrayList<String>())) : l.add(new WeightedItemstack(potionItem, (int)weights[0], weights[1], new ArrayList<String>())));
                            break;
                        }
                        EquipmentList.addItemTo(EquipmentSlotType.MAINHAND, item);
                        break;
                    }
                    case MAIN: {
                        EquipmentList.addItemTo(EquipmentSlotType.MAINHAND, item);
                        break;
                    }
                    case OFF: {
                        EquipmentList.addItemTo(EquipmentSlotType.OFFHAND, item);
                    }
                }
            }
            if (item instanceof ArmorItem) {
                switch (((ArmorItem)item).func_185083_B_()) {
                    case FEET: {
                        EquipmentList.addItemTo(EquipmentSlotType.FEET, item);
                        break;
                    }
                    case CHEST: {
                        EquipmentList.addItemTo(EquipmentSlotType.CHEST, item);
                        break;
                    }
                    case HEAD: {
                        EquipmentList.addItemTo(EquipmentSlotType.HEAD, item);
                        break;
                    }
                    case LEGS: {
                        EquipmentList.addItemTo(EquipmentSlotType.LEGS, item);
                    }
                }
            }
            if ((item instanceof SwordItem || item instanceof ToolItem) && !EquipmentList.defaultBlackLists(item)) {
                EquipmentList.addItemTo(EquipmentSlotType.MAINHAND, item);
            }
        });
    }

    private static void addItemTo(EquipmentSlotType slot, Item item) {
        float[] weights = EquipmentList.getDefaultWeight(item);
        equips.compute(slot, (s, l) -> l == null ? new WeightedItemstackList(new WeightedItemstack(item, (int)weights[0], weights[1])) : l.add(new WeightedItemstack(item, (int)weights[0], weights[1])));
    }

    private static boolean defaultBlackLists(Item item) {
        if (item instanceof ToolItem && !(item instanceof AxeItem)) {
            return true;
        }
        return item.getRegistryName().func_110624_b().equals("mobbattle");
    }

    private static float[] getDefaultWeight(Item item) {
        if (defaultZeroWeight.contains(item.getRegistryName().toString())) {
            return new float[]{0.0f, 0.0f};
        }
        int weight = 1500;
        float quality = 0.0f;
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            float fullProt = armor.func_200880_d().func_200902_b(EquipmentSlotType.HEAD) + armor.func_200880_d().func_200902_b(EquipmentSlotType.CHEST) + armor.func_200880_d().func_200902_b(EquipmentSlotType.LEGS) + armor.func_200880_d().func_200902_b(EquipmentSlotType.FEET);
            float toughness = armor.func_200880_d().func_200901_e();
            float averageDurability = (float)(armor.func_200880_d().func_200896_a(EquipmentSlotType.HEAD) + armor.func_200880_d().func_200896_a(EquipmentSlotType.CHEST) + armor.func_200880_d().func_200896_a(EquipmentSlotType.LEGS) + armor.func_200880_d().func_200896_a(EquipmentSlotType.FEET)) / 4.0f;
            if (averageDurability < 0.0f) {
                averageDurability = 0.0f;
            }
            float ench = armor.func_77619_b();
            float rep = armor.isRepairable(new ItemStack((IItemProvider)armor)) ? 0.9f : 1.15f;
            float vanillaMulti = armor.func_200880_d() == ArmorMaterial.LEATHER || armor.func_200880_d() == ArmorMaterial.GOLD || armor.func_200880_d() == ArmorMaterial.CHAIN || armor.func_200880_d() == ArmorMaterial.IRON || armor.func_200880_d() == ArmorMaterial.DIAMOND || armor.func_200880_d() == ArmorMaterial.NETHERITE || armor.func_200880_d() == ArmorMaterial.TURTLE ? 0.8f : 1.1f;
            weight = (int)((double)weight - ((double)(fullProt * fullProt) * 2.5 + (double)(toughness * toughness * 12.0f) + (double)averageDurability * 0.9 + (double)ench) * (double)rep * (double)vanillaMulti);
            quality = EquipmentList.defaultQualityFromWeight(weight);
        } else if (item instanceof SwordItem) {
            float dmg = 5.0f + ((SwordItem)item).func_200894_d();
            weight = (int)((double)weight - ((double)(dmg * dmg * 2.0f) + (double)item.func_77612_l() * 0.3));
            quality = EquipmentList.defaultQualityFromWeight(weight);
        } else if (item instanceof ToolItem) {
            ItemStack def = new ItemStack((IItemProvider)item);
            double dmg = 3.0 + ItemUtils.damage((ItemStack)def);
            weight = (int)((double)weight - (dmg * dmg * 2.0 + (double)item.func_77612_l() * 0.1));
            quality = EquipmentList.defaultQualityFromWeight(weight);
        } else if (item == Items.field_151033_d) {
            weight = 1200;
        } else if (item instanceof ShieldItem) {
            weight = 1350;
        } else if (item == Items.field_151129_at) {
            weight = 900;
        } else if (item == Items.field_151079_bi) {
            weight = 1100;
        } else if (item == Items.field_151126_ay) {
            weight = 1400;
        } else if (item instanceof ThrowablePotionItem) {
            weight = 1050;
        } else if (item instanceof BowItem) {
            weight = (int)(1300.0 - (double)item.func_77612_l() * 0.5);
        } else if (item == Items.field_151134_bR) {
            weight = 1100;
        } else if (item == Blocks.field_150335_W.func_199767_j()) {
            weight = 800;
        } else if (item == Items.field_203184_eO) {
            weight = 900;
        } else if (item instanceof CrossbowItem) {
            weight = 1000;
        }
        return new float[]{Math.max(weight, 1), quality};
    }

    private static boolean correctQuality(String itemString) {
        Item item;
        String itemReg = itemString;
        if (itemString.contains("{")) {
            int idx = itemString.indexOf("{");
            itemReg = itemString.substring(0, idx);
        }
        return (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemReg))) instanceof ArmorItem || item instanceof SwordItem || item instanceof ToolItem;
    }

    private static float defaultQualityFromWeight(int weight) {
        return (float)(1000 - weight) / 125.0f;
    }

    static {
        defaultZeroWeight = Lists.newArrayList((Object[])new String[]{"techguns:nucleardeathray", "techguns:grenadelauncher", "techguns:tfg", "techguns:guidedmissilelauncher", "techguns:rocketlauncher"});
    }

    public static class InvalidItemNameException
    extends Exception {
        private static final long serialVersionUID = -6736627280613384759L;

        public InvalidItemNameException(String message) {
            super(message);
        }
    }

    public static class WeightedItemstackList {
        private final List<WeightedItemstack> list = new ArrayList<WeightedItemstack>();
        private int totalWeight;
        private float lastModifier = -1.0f;

        public WeightedItemstackList(WeightedItemstack ... item) {
            this.list.addAll(Arrays.asList(item));
            this.list.removeIf(w -> ((WeightedItemstack)w).item == null);
        }

        public int getTotalWeight(float modifier) {
            if (this.lastModifier != modifier) {
                this.lastModifier = modifier;
                this.calculateTotalWeight(this.lastModifier);
            }
            return this.totalWeight;
        }

        private void calculateTotalWeight(float modifier) {
            this.totalWeight = this.list.stream().mapToInt(entry -> entry.getWeight(modifier)).sum();
        }

        public void finishList() {
            this.list.removeIf(w -> ((WeightedItemstack)w).weight == 0 && ((WeightedItemstack)w).quality <= 0.0f || this.modBlacklist(((WeightedItemstack)w).item.getItem()));
        }

        private boolean modBlacklist(Item item) {
            if (Config.CommonConfig.equipmentModWhitelist) {
                for (String s : Config.CommonConfig.equipmentModBlacklist) {
                    if (!item.getRegistryName().func_110624_b().equals(s)) continue;
                    return false;
                }
                return true;
            }
            for (String s : Config.CommonConfig.equipmentModBlacklist) {
                if (!item.getRegistryName().func_110624_b().equals(s)) continue;
                return true;
            }
            return false;
        }

        public WeightedItemstackList add(WeightedItemstack item) {
            if (item.item == null) {
                return this;
            }
            this.list.remove(item);
            this.list.add(item);
            return this;
        }

        public String toString() {
            return String.format("TotalWeight: %d ; [%s]", this.totalWeight, this.list.toString());
        }
    }

    public static class WeightedItemstack
    implements Comparable<WeightedItemstack> {
        private final ExtendedItemStackWrapper item;
        public final String configString;
        private final int weight;
        private final float quality;

        public WeightedItemstack(Item item, int itemWeight, float quality) {
            this.weight = itemWeight;
            this.quality = quality;
            this.item = new ExtendedItemStackWrapper(item.getRegistryName().toString());
            this.configString = item.getRegistryName().toString();
        }

        public WeightedItemstack(String item, int itemWeight, float quality, List<String> errors) {
            this.weight = itemWeight;
            this.quality = quality;
            this.configString = item;
            String itemReg = item;
            CompoundNBT nbt = null;
            if (item.contains("{")) {
                int idx = item.indexOf("{");
                itemReg = item.substring(0, idx);
                try {
                    nbt = JsonToNBT.func_180713_a((String)item.substring(idx));
                }
                catch (CommandSyntaxException e) {
                    ImprovedMobs.logger.error("Error reading nbt from config {}", (Object)item.substring(idx));
                    e.printStackTrace();
                }
            }
            if (!ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemReg))) {
                errors.add(itemReg);
                this.item = null;
            } else {
                this.item = new ExtendedItemStackWrapper(itemReg).setNBT(nbt);
            }
        }

        public ItemStack getItem() {
            return this.item.getStack();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof WeightedItemstack) {
                WeightedItemstack oth = (WeightedItemstack)other;
                if (!this.item.getItem().getRegistryName().equals((Object)oth.item.getItem().getRegistryName())) {
                    return false;
                }
                if (this.item.getTag() == null && oth.item.getTag() != null) {
                    return false;
                }
                return this.item.getTag() == null || this.item.getTag().equals((Object)oth.item.getTag());
            }
            return false;
        }

        public int hashCode() {
            return (this.item.getItem().getRegistryName() + (this.item.getTag() != null ? this.item.getTag().toString() : "")).hashCode();
        }

        @Override
        public int compareTo(WeightedItemstack o) {
            return this.item.getItem().getRegistryName().toString().compareTo(o.item.getItem().getRegistryName().toString());
        }

        public String toString() {
            return String.format("Item: %s; Weight: %d", this.item.getItem().getRegistryName().toString(), this.weight);
        }

        public int getWeight(float modifier) {
            return Math.max(this.weight + MathHelper.func_76141_d((float)(modifier * this.quality)), 0);
        }
    }
}

